from requests import get
from datetime import *
import os 

uri = "http://HOME_ASSISTANT_IP:PORT"
long_lived_access_token = "YOUR_ACCESS_TOKEN" #Can be created in user profile
sensor_id = "sensor.YOUR_SENSOR_ID" #Can be found in the details of an entity
filename = "data.csv"

def get_data(sensor):
    url = uri + "/api/states/" + sensor
    headers = {
        "Authorization": "Bearer " + long_lived_access_token,
        "content-type": "application/json",
    }
    response = get(url, headers=headers)
    if '{"message":"Entity not found."}' == response.text:
        print("Sensor not found")
        return
    return response.text

def get_attrib(response,attrib):
    index = response.index(attrib)+len(attrib)+3
    return response[index:index+8].split('"')[0]

def get_val(sensor):
    response = get_data(sensor)
    return get_attrib(response,"state")+get_attrib(response,"unit_of_measurement")
    
def get_history(sensor,timestamp):
    print("Starting from:",timestamp,"\n")
    url = uri + "/api/history/period/" + timestamp
    params = {
        "filter_entity_id": sensor,
        "minimal_response": True,
        "no_attributes": True,
        "end_time": datetime.now()
    }
    headers = {
        "Authorization": "Bearer " + long_lived_access_token,
        "content-type": "application/json",
    }
    response = get(url, headers=headers, params=params)
    values = response.text.replace("},{","\n")
    values = values.replace('"state":',"")
    values = values.replace('"last_changed":',"")
    values = values.replace('"',"")
    try:
        return values[values.index("\n")+1:-3]
    except:
        return ""

dir_path = os.path.dirname(os.path.realpath(__file__))
last_line = ""
start_date_str = "2000-01-01T00:00:00+00:00"

try:
    last_line = open(dir_path+"/"+filename).readlines()[-1]
except:
    print("Creating file")
    open(dir_path+"/"+filename,'x').write("Value,Date")
print("Writing in dir",dir_path)

if last_line != "":
    last_date = last_line.split(',')[1]
    if last_date[0] == '"':
        last_date = last_date[1:]
    start_date = datetime.strptime(last_date.split(".")[0], "%Y-%m-%dT%H:%M:%S")
    start_date += timedelta(seconds=1)
    start_date_str = str(start_date)+"+00:00"
values = get_history(sensor_id,start_date_str)
print(values)
no_values = values.count(",")
if no_values > 0:
    open(dir_path+"/"+filename,'a').write("\n"+values)
print(no_values,"new values added")